import { Test, TestingModule } from '@nestjs/testing';
import { INestApplication, ValidationPipe } from '@nestjs/common';
import * as request from 'supertest';
import { AppModule } from './../src/app.module';

describe('MachineController (e2e)', () => {
  let app: INestApplication;

  beforeAll(async () => {
    const moduleFixture: TestingModule = await Test.createTestingModule({
      imports: [AppModule],
    }).compile();

    app = moduleFixture.createNestApplication();
    app.useGlobalPipes(new ValidationPipe()); // Optional if using validation
    await app.init();
  });

  afterAll(async () => {
    await app.close();
  });

  describe('GET /machines', () => {
    it('should return all machines', async () => {
      const response = await request(app.getHttpServer())
        .get('/machines')
        .expect(200);

      expect(Array.isArray(response.body)).toBe(true);
      expect(response.body[0]).toHaveProperty('id');
      expect(response.body[0]).toHaveProperty('name');
    });
  });

  describe('GET /machines/:id', () => {
    it('should return a machine by ID', async () => {
      const response = await request(app.getHttpServer())
        .get('/machines/1')
        .expect(200);

      expect(response.body).toHaveProperty('id', 1);
      expect(response.body).toHaveProperty('name');
    });

    it('should return 404 if machine not found', async () => {
      await request(app.getHttpServer())
        .get('/machines/9999')
        .expect(404);
    });
  });

  describe('GET /machines/:id/node', () => {
    it('should return nodeId for machine', async () => {
      const response = await request(app.getHttpServer())
        .get('/machines/1/node')
        .expect(200);

      expect(response.body).toHaveProperty('nodeId');
    });

    it('should return 404 if node not found', async () => {
      await request(app.getHttpServer())
        .get('/machines/9999/node')
        .expect(404);
    });
  });
});
